#ifndef CEXPORTDIALOG_H
#define CEXPORTDIALOG_H

#include <QDialog>

namespace Ui {
    class CExportDialog;
}

class ExportController;

class CExportDialog : public QDialog {
    Q_OBJECT
public:
    CExportDialog(ExportController* controller, QWidget *parent = 0);
    ~CExportDialog();

    QString 	lastExportPath() const;
    ulong 		lastExportFlags() const;

public slots:
    int exec(QString fileName);
    void tryAccept();
    void selectFile();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::CExportDialog*	ui;
    ExportController* 	m_exportController;
    QString 			m_lastExportPath;
    ulong 				m_lastExportFlags;
};

#endif // CEXPORTDIALOG_H
